#pragma once

#include "gmplugin.h"

struct PlayerWeaponData 
{
	const WeaponDefinitionClass *LastWeapon;
	const AmmoDefinitionClass *LastAmmo;
	int LastActive;
	const WeaponDefinitionClass *CurrWeapon;
	const AmmoDefinitionClass *CurrAmmo;
	int Hits;
	int HitMultiplier;
	int LastRangeCheck;
};

class RangeRoFDetection : public Plugin
{	
	StringClass helloWorldString;

public:
	
	RangeRoFDetection();
	~RangeRoFDetection();

	virtual void OnLoadLevel();
	virtual void OnPlayerLeave(int PlayerID);
	virtual void OnThink();
	virtual bool OnTtDamage(PhysicalGameObj* damager, PhysicalGameObj* target, const AmmoDefinitionClass* ammo, const char* bone);
	virtual bool OnStockDamage(PhysicalGameObj* damager, PhysicalGameObj* target, float damage, uint warheadId);
};

void Init_Weapon_Data_Player(int PlayerID);
void Console(const char *Format, ...);
void DamageDone(int PlayerID, int VictimID);
void SpectateDetection(int PlayerID, int ObjID, int VictimID, int WarheadID, float Damage);